import { NextResponse } from 'next/server'
import fs from 'fs'
import path from 'path'

export async function GET() {
  try {
    const filePath = path.join(process.cwd(), 'data', 'products.json')
    const fileContents = fs.readFileSync(filePath, 'utf8')
    const products = JSON.parse(fileContents)
    return NextResponse.json(products)
  } catch (error) {
    console.error('Error reading products:', error)
    return NextResponse.json({ error: 'Failed to load products' }, { status: 500 })
  }
}

export async function POST(request: Request) {
  try {
    const products = await request.json()
    const filePath = path.join(process.cwd(), 'data', 'products.json')
    fs.writeFileSync(filePath, JSON.stringify(products, null, 2), 'utf8')
    return NextResponse.json({ success: true, message: 'Products saved successfully' })
  } catch (error) {
    console.error('Error saving products:', error)
    return NextResponse.json({ error: 'Failed to save products' }, { status: 500 })
  }
}

